/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef _dbg_lib_h_
#define _dbg_lib_h_

#include <syslog.h>
#include <sys/prctl.h>
#include <dtvrecdd/moduleid.h>

#define DBG_SET_THREAD_NAME_ENABLE 1

#define MODULE_MAX_NUM 256

typedef unsigned int DBG_MID;
typedef unsigned int DBG_MPID;

typedef int DBG_ER;

typedef struct DBG_MOD_TBL_t{
  DBG_MID Module_id;
  unsigned int out_pattern;
} DBG_MOD_TBL;

typedef struct DBG_OUTPUT_TBL_t{
  unsigned char sys_level;
  DBG_MOD_TBL dbg_mod_table[MODULE_MAX_NUM];
} DBG_OUTPUT_TBL;

#define DBG_LOG_CRIT    LOG_CRIT
#define DBG_LOG_ERR     LOG_ERR
#define DBG_LOG_WARNING LOG_DEBUG
#define DBG_LOG_INFO    LOG_DEBUG
#define DBG_LOG_DEBUG   LOG_DEBUG

#define DBG_LOG_STATE   LOG_INFO

#define DBG_E_OK        0
#define DBG_E_PARAM     1

#if !defined(DBG_LEVEL)
#define DBG_LEVEL       DBG_LOG_DEBUG
#endif

#define USUAL_SELECT    0
#define USUAL_SYSLOG    1
#define USUAL_PRINTF    2
#define USUAL_PROFILE   3

extern int dbg_init( DBG_MPID mpid );
extern void dbg_output( int usual, DBG_MID id, long long output_kind, char *format, ... ) __attribute__ ((__format__ (__printf__, 4, 5)));
extern unsigned int dbg_search_module_index( DBG_MID id );
extern unsigned int dbg_search_module_index_str( char *name );

extern DBG_ER DBG_Change_OutPattern(DBG_MOD_TBL *tbl);
extern DBG_ER DBG_Change_SysLevel(unsigned char SysLevel);

#if defined(DBG_ENABLE)

#define DBG_INIT( mpid )  dbg_init( mpid )

#if defined(DBG_SYSLOG) | defined(DBG_PRINTF) | defined(DBG_PROFILE)
#if defined(DBG_SYSLOG)
#define DBG_OUTPUT( id, level, format, arg... ) \
        dbg_output( USUAL_SYSLOG, id, level, format, ##arg );
#endif
#if defined(DBG_PRINTF)
#define DBG_OUTPUT( id, level, format, arg... ) \
        dbg_output( USUAL_PRINTF, id, level, format, ##arg );
#endif
#if defined(DBG_PROFILE)
#define DBG_OUTPUT( id, level, format, arg... ) {\
        if( level <= DBG_LEVEL ){ \
                dbg_output( USUAL_PROFILE, id, level, format, ##arg );\
        } \
}
#endif
#else 
#define DBG_OUTPUT( id, level, format, arg... ) \
        dbg_output( USUAL_SELECT, id, level, format, ##arg );

#endif
#else

#define DBG_INIT( mpid )
#define DBG_OUTPUT( id, level, format, arg... )


#endif

#if defined(DBG_SET_THREAD_NAME_ENABLE)
#define DBG_SET_THREAD_NAME(name)	prctl(PR_SET_NAME, name)
#else   
#define DBG_SET_THREAD_NAME(name)
#endif  

#endif 
